package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.ETrainTicketRefundState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomTrainTicketRefundRepository {
    List<UUID> getTicketRefundsForCheck(Instant now,
                                        ETrainTicketRefundState state,
                                        EWorkflowState workflowState,
                                        Collection<UUID> excludeIds,
                                        Pageable pageable);

    long countTicketRefundsForCheck(Instant now,
                                    ETrainTicketRefundState state,
                                    EWorkflowState workflowState,
                                    Collection<UUID> excludeIds);
}
