package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.invoice.proto.ETrustInvoiceState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomTrustInvoiceRepository {
    List<UUID> getInvoiceIdsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                                 ETrustInvoiceState invoiceState,
                                                                 EWorkflowState workflowState,
                                                                 Collection<UUID> exclusions,
                                                                 Pageable pageable);

    long countInvoicesAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                           ETrustInvoiceState invoiceState,
                                                           EWorkflowState workflowState,
                                                           Collection<UUID> exclusions);


    List<UUID> getInvoiceIdsWaitingClearingWithExclusions(Instant nextClearTime,
                                                          ETrustInvoiceState invoiceState,
                                                          EWorkflowState workflowState,
                                                          Collection<UUID> exclusions,
                                                          Pageable pageable);

    long countInvoicesWaitingForClearanceWithExclusions(Instant nextClearTime,
                                                        ETrustInvoiceState invoiceState,
                                                        EWorkflowState workflowState,
                                                        Collection<UUID> exclusions);
}
