package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherState;
import ru.yandex.travel.workflow.EWorkflowState;

@Component
@Slf4j
@RequiredArgsConstructor
public class CustomVoucherRepositoryImpl implements CustomVoucherRepository {
    private final EntityManager entityManager;

    private String commonJpaQl(String sqlPart) {
        return "SELECT " + sqlPart + " FROM ru.yandex.travel.orders.entities.Voucher i " +
                "inner join i.workflow w " +
                "where i.nextCheckCreatedAt is not null and i.nextCheckCreatedAt <= :nextCheckCreatedAt " +
                "AND w.state = :workflowState " +
                "AND i.state = :state ";
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<UUID> getVouchersNextCheckCreatedAt(Instant nextCheckCreatedAtTill,
                                                    EVoucherState state,
                                                    EWorkflowState workflowState,
                                                    Pageable pageable) {
        Query query = entityManager.createQuery(commonJpaQl("i.id") + " order by i.nextCheckCreatedAt");
        query.setParameter("nextCheckCreatedAt", nextCheckCreatedAtTill);
        query.setParameter("state", state);
        query.setParameter("workflowState", workflowState);
        query.setFirstResult(Long.valueOf(pageable.getOffset()).intValue());
        query.setMaxResults(pageable.getPageSize());
        return query.getResultList();
    }

    @Override
    public long countVouchersNextCheckCreatedAt(Instant nextCheckCreatedAtTill,
                                                EVoucherState state,
                                                EWorkflowState workflowState) {
        Query query = entityManager.createQuery(commonJpaQl("count(i.id)"));
        query.setParameter("nextCheckCreatedAt", nextCheckCreatedAtTill);
        query.setParameter("state", state);
        query.setParameter("workflowState", workflowState);
        return (Long) query.getResultList().get(0);
    }
}
