package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomYandexPlusTopupRepository {
    List<UUID> getTopupIdsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                               EYandexPlusTopupState invoiceState,
                                                               EWorkflowState workflowState,
                                                               Collection<UUID> exclusions,
                                                               Pageable pageable);

    long countTopupsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                         EYandexPlusTopupState invoiceState,
                                                         EWorkflowState workflowState,
                                                         Collection<UUID> exclusions);
}
