package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.workflow.EWorkflowState;

@Component
@Slf4j
@RequiredArgsConstructor
public class CustomYandexPlusTopupRepositoryImpl implements CustomYandexPlusTopupRepository {

    private final EntityManager entityManager;

    @SuppressWarnings("unchecked")
    @Override
    public List<UUID> getTopupIdsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                                      EYandexPlusTopupState topupState,
                                                                      EWorkflowState workflowState,
                                                                      Collection<UUID> exclusions,
                                                                      Pageable pageable) {
        Query query = entityManager.createQuery(commonJpaQl("i.id", exclusions) + " order by i.nextCheckStatusAt");
        query.setParameter("nextCheckStatusAt", nextCheckStatusAt);
        query.setParameter("topupState", topupState);
        query.setParameter("workflowState", workflowState);
        if (!exclusions.isEmpty()) {
            query.setParameter("exclusions", exclusions);
        }
        query.setFirstResult(Long.valueOf(pageable.getOffset()).intValue());
        query.setMaxResults(pageable.getPageSize());
        return query.getResultList();
    }

    @Override
    public long countTopupsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                                EYandexPlusTopupState topupState,
                                                                EWorkflowState workflowState,
                                                                Collection<UUID> exclusions) {

        Query query = entityManager.createQuery(commonJpaQl("count(i.id)", exclusions));
        query.setParameter("nextCheckStatusAt", nextCheckStatusAt);
        query.setParameter("topupState", topupState);
        query.setParameter("workflowState", workflowState);
        if (!exclusions.isEmpty()) {
            query.setParameter("exclusions", exclusions);
        }
        return (Long) query.getResultList().get(0);
    }

    private String commonJpaQl(String sqlPart, Collection<UUID> exclusions) {
        return "SELECT " + sqlPart + " FROM ru.yandex.travel.orders.entities.YandexPlusTopup i " +
                "inner join i.workflow w " +
                "where i.nextCheckStatusAt is not null and i.nextCheckStatusAt <= :nextCheckStatusAt " +
                (exclusions.isEmpty() ? "" : "AND i.id NOT IN (:exclusions) ") +
                "AND w.state = :workflowState AND i.backgroundJobActive = true " +
                "AND i.state = :topupState";
    }
}
