package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.DolphinOrderItem;
import ru.yandex.travel.orders.workflow.hotels.dolphin.proto.EDolphinItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface DolphinOrderItemRepository extends JpaRepository<DolphinOrderItem, UUID> {
    DolphinOrderItem getByDolphinOrderCode(String orderCode);

    List<DolphinOrderItem> getAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotInOrderByExpiresAtAsc(
            Collection<EDolphinItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds,
            Pageable pageable
    );

    Long countAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotIn(
            Collection<EDolphinItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds
    );
}
