package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.EExpediaItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface ExpediaOrderItemRepository extends JpaRepository<ExpediaOrderItem, UUID> {
    List<ExpediaOrderItem> getAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotInOrderByExpiresAtAsc(
            Collection<EExpediaItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds,
            Pageable pageable
    );

    Long countAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotIn(
            Collection<EExpediaItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds
    );
}
