package ru.yandex.travel.orders.repository;

import java.util.Collection;
import java.util.List;

import javax.persistence.Tuple;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.entities.finances.FinancialEvent;
import ru.yandex.travel.orders.entities.finances.FinancialEventType;
import ru.yandex.travel.orders.entities.finances.ProcessingTasksInfo;

import static ru.yandex.travel.orders.repository.BillingTransactionRepository.convertProcessingTasksInfo;

public interface FinancialEventRepository extends JpaRepository<FinancialEvent, Long> {
    Collection<Long> NO_EXCLUDE_IDS = List.of(-1L);

    @Query("select e.id from FinancialEvent e " +
            "join BillingPartnerConfig c on c.billingClientId = e.billingClientId " +
            "where e.processed = false and e.id not in ?1 and c.generateTransactions = true")
    List<Long> findUnprocessedIds(Collection<Long> excludeIds, Pageable pageable);

    @Query("select count(*) from FinancialEvent e " +
            "join BillingPartnerConfig c on c.billingClientId = e.billingClientId " +
            "where e.processed = false and e.id not in ?1 and c.generateTransactions = true")
    Long countUnprocessedIds(Collection<Long> excludeIds);

    @Query("select min(e.accrualAt), count(*) from FinancialEvent e " +
            "join BillingPartnerConfig c on c.billingClientId = e.billingClientId " +
            "where e.processed = false and c.generateTransactions = true")
    Tuple findOldestUnprocessedTimestampRaw();
    default ProcessingTasksInfo findOldestUnprocessedTimestamp() {
        return convertProcessingTasksInfo(findOldestUnprocessedTimestampRaw());
    }

    List<FinancialEvent> findAllByOrder(Order order);

    List<FinancialEvent> findAllByOrderItem(OrderItem orderItem);

    FinancialEvent findFirstByOrderItemAndTypeOrderByIdAsc(OrderItem orderItem, FinancialEventType type);

    FinancialEvent findFirstByOrderPrettyIdAndTypeOrderByIdAsc(String orderPrettyId, FinancialEventType type);

    default FinancialEvent findOriginalPaymentEvent(OrderItem orderItem) {
        return findFirstByOrderItemAndTypeOrderByIdAsc(orderItem, FinancialEventType.PAYMENT);
    }
}
