package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.FiscalReceipt;
import ru.yandex.travel.orders.entities.FiscalReceiptState;

public interface FiscalReceiptRepository extends JpaRepository<FiscalReceipt, Long> {
    @Query("select f.id from ru.yandex.travel.orders.entities.FiscalReceipt f where f.nextRefreshAt is not null and f" +
            ".nextRefreshAt <= :nextRefreshAt AND f.state = :state order by f.nextRefreshAt")
    List<Long> getIdsOfFiscalReceiptsWithNextRefreshBeforeAndInState(@Param("nextRefreshAt") Instant nextRefreshAt,
                                                                     @Param("state") FiscalReceiptState state,
                                                                     Pageable pageable);

    @Query("select count(f.id) from ru.yandex.travel.orders.entities.FiscalReceipt f where f.nextRefreshAt is not " +
            "null and f.nextRefreshAt <= :nextRefreshAt AND f.state = :state")
    long countFiscalReceiptsWithNextRefreshBeforeAndInState(@Param("nextRefreshAt") Instant nextRefreshAt,
                                                            @Param("state") FiscalReceiptState state);
}
