package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.HotelOrderItem;
import ru.yandex.travel.orders.entities.OrderItem;

public interface HotelDBoyOrderItemRepository extends JpaRepository<OrderItem, UUID> {

    @Query("FROM OrderItem oi join oi.order o WHERE o.updatedAt BETWEEN ?1 and ?2" +
            " AND TYPE(oi) in (TravellineOrderItem, BNovoOrderItem)" +
            " ORDER BY o.updatedAt ASC"
    )
    List<HotelOrderItem> getRecentDBoyOrders(
            Instant updatedFrom,
            Instant updatedTill,
            Pageable pageable
    );
}
