package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.Invoice;

public interface InvoiceRepository extends JpaRepository<Invoice, UUID> {
    @Query(value = "select i.* from invoices i " +
            "where i.updated_at >= ?1 and i.updated_at < ?2 and i.invoice_type in (?3)",
            nativeQuery = true)
    List<Invoice> findByUpdatedAtAndType(Instant from, Instant to, Collection<String> types);
}
