package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.NotifierStateChange;

public interface NotifierStateChangeRepository extends JpaRepository<NotifierStateChange, Long> {
    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Query(value = "SELECT cast(order_id as varchar) FROM notifier_state_changes sc " +
            "WHERE sc.order_id not in ?1 AND sc.created_at < ?2 " +
            "GROUP BY sc.order_id LIMIT ?3", nativeQuery = true)
    List<String> getOrdersWaitingStateRefresh(Collection<UUID> excluded, Instant delayed, int limit);

    @Query(value = "SELECT COUNT(DISTINCT sc.order_id) FROM notifier_state_changes sc " +
            "WHERE sc.order_id not in ?1 AND sc.created_at < ?2 ",
            nativeQuery = true)
    Long countOrdersWaitingStateRefresh(Collection<UUID> excluded, Instant delayed);

    @Query(value = "SELECT max(sc.id) FROM NotifierStateChange sc WHERE sc.orderId = ?1")
    Long findMaxIdForOrder(UUID orderId);

    @Modifying
    @Query("DELETE FROM NotifierStateChange sc WHERE sc.orderId = :orderId AND sc.id <= :maxChangeId")
    void cleanupByOrderIdAndIdLessThanEqual(@Param("orderId") UUID orderId, @Param("maxChangeId") Long maxChangeId);
}
