package ru.yandex.travel.orders.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.OrderAggregateStateChange;

public interface OrderAggregateStateChangeRepository extends JpaRepository<OrderAggregateStateChange, Long> {
    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    //    @Query(value = "SELECT cast(order_id as varchar), min(created_at) FROM order_aggregate_state_changes oag " +
//            "WHERE oag.order_id not in ?1 GROUP BY order_id ORDER BY 2 LIMIT ?2",
//            nativeQuery = true
//    )
//List<Object[]> getOrdersWaitingAggregateStateRefresh(Collection<UUID> excluded, int limit);
    @Query(value = "SELECT cast(order_id as varchar) order_id FROM " +
            "order_aggregate_state_changes oag " +
            " WHERE oag.order_id not in ?1 " +
            " GROUP BY order_id " +
            " ORDER BY min(created_at) " +
            " LIMIT ?2",
            nativeQuery = true
    )
    List<String> getOrdersWaitingAggregateStateRefresh(Collection<UUID> excluded, int limit);

    @Query("SELECT COUNT(DISTINCT oag.orderId) FROM OrderAggregateStateChange oag " +
            "WHERE oag.orderId not in ?1")
    Long countOrdersWaitingAggregateStateRefresh(Collection<UUID> excluded);

    @Query(value = "select max(oag.id) from order_aggregate_state_changes oag where oag.order_id = ?1",
            nativeQuery = true)
    Long findMaxIdForOrder(UUID orderId);

    @Modifying
    @Query("DELETE FROM OrderAggregateStateChange o WHERE o.orderId = :orderId AND o.id <= :maxChangeId")
    void cleanupByOrderIdAndIdLessThanEqual(@Param("orderId") UUID orderId, @Param("maxChangeId") Long maxChangeId);
}
