package ru.yandex.travel.orders.repository;

import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.OrderChange;

public interface OrderChangeRepository extends JpaRepository<OrderChange, UUID>, CustomOrderChangeRepository {

    @Query(value = "select max(oc.id) from order_changes oc where oc.order_id = ?1",
            nativeQuery = true)
    Long findMaxIdForOrder(UUID orderId);

    @Modifying
    @Query("DELETE FROM OrderChange o WHERE o.orderId = :orderId AND o.id <= :maxChangeId")
    void cleanupByOrderIdAndIdLessThanEqual(@Param("orderId") UUID orderId, @Param("maxChangeId") Long maxChangeId);
}
