package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.OrderItem;

public interface OrderItemRepository extends JpaRepository<OrderItem, UUID> {
    @Query(value = "select oi.* from order_items oi " +
            "where oi.updated_at >= ?1 and oi.updated_at < ?2 and oi.item_type in (?3)",
            nativeQuery = true)
    List<OrderItem> findByUpdatedAtAndType(Instant from, Instant to, Collection<String> types);
}
