package ru.yandex.travel.orders.repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.Order;

public interface OrderRepository extends JpaRepository<Order, UUID>, CustomOrderRepository {

    Order getOrderByDeduplicationKey(UUID deduplicationKey);

    @Query(value = "select nextval('orders_pretty_id_seq')", nativeQuery = true)
    Long getNextPrettyIdSequenceValue();

    Order getOrderByPrettyId(String prettyId);

    Optional<Order> findOrderByPrettyId(String prettyId);

    @Query(value = "select order_type, display_type, state, count(*) from orders " +
            "group by order_type, display_type, state",
            nativeQuery = true)
    List<Object[]> countOrdersByTypesAndState();

}
