package ru.yandex.travel.orders.repository;

import java.util.UUID;
import java.util.stream.Stream;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.entities.Order;

public interface OrderTakeoutRepository extends JpaRepository<Order, UUID> {
    @Query("select o from ru.yandex.travel.orders.entities.Order o " +
            "inner join ru.yandex.travel.orders.entities.AuthorizedUser au on au.id.orderId = o.id " +
            "where au.id.passportId = ?1 " +
            " and au.role = 'OWNER' " +
            " and o.displayType = ?2 " +
            "order by o.createdAt")
    Stream<Order> streamOrdersOwnedByUser(String userPassportId, EDisplayOrderType displayType);

    @Query("select o from ru.yandex.travel.orders.entities.Order o " +
            "inner join ru.yandex.travel.orders.entities.AuthorizedUser au on au.id.orderId = o.id " +
            "where au.id.passportId = ?1 " +
            " and au.role = 'OWNER' " +
            "order by o.createdAt")
    Stream<Order> streamOrdersOwnedByUser(String userPassportId);
}
