package ru.yandex.travel.orders.repository;

import java.util.List;

import javax.persistence.DiscriminatorValue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ProtocolMessageEnum;
import lombok.Data;

import ru.yandex.travel.orders.entities.Order;

@Data
public class OrderTypeWithStatesCriteria {
    private String orderType;
    private List<ProtocolMessageEnum> states;

    public OrderTypeWithStatesCriteria(Class<? extends Order> orderTypeClass, List<ProtocolMessageEnum> states) {
        DiscriminatorValue discriminatorValue = orderTypeClass.getAnnotation(DiscriminatorValue.class);
        Preconditions.checkArgument(discriminatorValue != null, "Order type with discriminator value must be present");
        this.orderType = discriminatorValue.value();
        this.states = ImmutableList.copyOf(states);
    }
}
