package ru.yandex.travel.orders.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.OrdersUpdatesQueueStateChange;

public interface OrdersUpdatesQueueStateChangeRepository extends JpaRepository<OrdersUpdatesQueueStateChange, Long> {
    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Query(value = "SELECT DISTINCT cast(order_id as varchar) FROM orders_updates_queue_state_changes sc " +
            "WHERE sc.order_id not in ?1 " +
            "LIMIT ?2", nativeQuery = true)
    List<UUID> getOrdersWaitingStateRefresh(Collection<UUID> excluded, int limit);

    @Query(value = "SELECT COUNT(DISTINCT sc.order_id) FROM orders_updates_queue_state_changes sc " +
            "WHERE sc.order_id not in ?1",
            nativeQuery = true)
    Long countOrdersWaitingStateRefresh(Collection<UUID> excluded);

    @Query(value = "SELECT sc.* FROM orders_updates_queue_state_changes sc " +
            "WHERE sc.id = (" +
            "   SELECT MAX(osc.id) FROM orders_updates_queue_state_changes osc WHERE osc.order_id = ?1)",
            nativeQuery = true)
    OrdersUpdatesQueueStateChange findMostRecentStateChangeForOrder(UUID orderId);

    @Modifying
    @Query("DELETE FROM OrdersUpdatesQueueStateChange sc WHERE sc.orderId = :orderId AND sc.id <= :maxChangeId")
    void cleanupByOrderIdAndIdLessThanEqual(@Param("orderId") UUID orderId, @Param("maxChangeId") Long maxChangeId);
}
