package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.SimpleTrustRefund;

public interface SimpleTrustRefundRepository extends JpaRepository<SimpleTrustRefund, UUID>,
        CustomSimpleTrustRefundRepository {
    List<SimpleTrustRefund> findAllByInvoiceId(UUID invoiceId);

    Optional<SimpleTrustRefund> findByTrustRefundIdEquals(String trustRefundId);

    List<SimpleTrustRefund> findByCreatedAtBetween(Instant from, Instant to);
}
