package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.workflow.EWorkflowState;


public interface SuburbanOrderItemRepository extends JpaRepository<SuburbanOrderItem, UUID> {
    Collection<UUID> EMPTY_EXCLUDE_UIDS = List.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    String EXPIRED_QUERY = " FROM SuburbanOrderItem oi "
            + "JOIN Workflow w ON oi.workflow.id = w.id "
            + "WHERE oi.isExpired = false "
            + "AND oi.state IN (:itemStates) "
            + "AND w.state = :workflowState "
            + "AND oi.expiresAt < :expiredAt "
            + "AND oi.id NOT IN (:excludeIds)";

    @Query("SELECT oi.id " + EXPIRED_QUERY)
    List<UUID> getExpiredOrderItems(
            @Param("expiredAt") Instant expiredAt,
            @Param("itemStates") Collection<EOrderItemState> itemStates,
            @Param("workflowState") EWorkflowState workflowState,
            @Param("excludeIds") Collection<UUID> excludeIds,
            Pageable pageable);

    @Query("SELECT count(1) " + EXPIRED_QUERY)
    long countExpiredOrderItems(
            @Param("expiredAt") Instant expiredAt,
            @Param("itemStates") Collection<EOrderItemState> itemStates,
            @Param("workflowState") EWorkflowState workflowState,
            @Param("excludeIds") Collection<UUID> excludeIds);
}
