package ru.yandex.travel.orders.repository;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.TakeoutJob;
import ru.yandex.travel.orders.takeout.proto.ETakeoutJobState;
import ru.yandex.travel.orders.takeout.proto.ETakoutJobType;

public interface TakeoutJobRepository extends JpaRepository<TakeoutJob, UUID> {
    Collection<UUID> NO_EXCLUDE_IDS = List.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Query("select j FROM ru.yandex.travel.orders.entities.TakeoutJob j where user_passport_id = ?1 and type = ?2 " +
            "order by updated_at DESC")
    List<TakeoutJob> getLastJobByPassportId(String passportId, ETakoutJobType type, Pageable pageable);

    @Query("select j.id FROM ru.yandex.travel.orders.entities.TakeoutJob j where j.state = ?2 and j.id not in ?1")
    List<UUID> getJobsIdsByState(Collection<UUID> excluded, ETakeoutJobState states, Pageable pageable);

    @Query("select count(*) FROM ru.yandex.travel.orders.entities.TakeoutJob j where j.state = ?2 and j.id not in ?1")
    long countJobsByState(Collection<UUID> excluded, ETakeoutJobState states);
}
