package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.TrainDiscount;

public interface TrainDiscountRepository extends JpaRepository<TrainDiscount, Long> {
    @Query(value = "select d from TrainDiscount d where d.departureTime = :departureTime " +
            "and d.trainNumber = :trainNumber and d.documentNumber in :documentNumbers")
    List<TrainDiscount> findDiscounts(
            @Param("departureTime") Instant departureTime,
            @Param("trainNumber") String trainNumber,
            @Param("documentNumbers") Collection<String> documentNumbers);

    void deleteAllByOrderItemId(UUID orderItemId);

    void deleteAllByOrderItemIdAndDocumentNumber(UUID orderItemId, String documentNumber);
}
