package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.workflow.hotels.travelline.proto.ETravellineItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface TravellineOrderItemRepository extends JpaRepository<TravellineOrderItem, UUID> {
    List<TravellineOrderItem> getAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotInOrderByExpiresAtAsc(
            Collection<ETravellineItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds,
            Pageable pageable
    );

    Long countAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotIn(
            Collection<ETravellineItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds
    );
}
