package ru.yandex.travel.orders.repository;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.UserOrderCounter;

public interface UserOrderCounterRepository extends JpaRepository<UserOrderCounter, Long> {

    @Query("SELECT u FROM UserOrderCounter u WHERE confirmedHotelOrders > 0")
    List<UserOrderCounter> findNextUserOrderCounterWithHotelOrders(Pageable pageable);
}
