package ru.yandex.travel.orders.repository;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.Voucher;
import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherState;
import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherType;

public interface VoucherRepository extends JpaRepository<Voucher, UUID>, CustomVoucherRepository {
    List<Voucher> findAllByOrderId(UUID orderId);

    @Query(value =
            "select v from Voucher v where " +
            "   v.orderId = :orderId and" +
            "   v.voucherType = :voucherType and" +
            "   v.state in :voucherStates")
    List<Voucher> findForOrderByTypesAndStates(
            @Param("orderId") UUID orderId,
            @Param("voucherType") EVoucherType voucherType,
            @Param("voucherStates") Set<EVoucherState> voucherStates);
}
