package ru.yandex.travel.orders.repository.cpa;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;

public interface CpaAeroflotOrderRepository extends JpaRepository<AeroflotOrder, UUID> {
    List<AeroflotOrder> findByCreatedAtAfterAndCreatedAtBeforeAndStateIn(Instant createdAtFrom, Instant createdAtTo,
                                                                         List<EAeroflotOrderState> aeroflotOrderStates);

    @Deprecated
    List<AeroflotOrder> findByUpdatedAtAfterAndUpdatedAtBeforeAndStateIn(Instant updatedAtFrom, Instant updatedAtTo,
                                                                         List<EAeroflotOrderState> aeroflotOrderStates);

    List<AeroflotOrder> findByUpdatedAtAfterAndUpdatedAtBeforeAndStateInOrderByUpdatedAtAsc(Instant updatedAtFrom,
                                                                                            Instant updatedAtTo,
                                                                                            List<EAeroflotOrderState> aeroflotOrderStates,
                                                                                            Pageable pageable);
}
