package ru.yandex.travel.orders.repository.cpa;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;

public interface CpaHotelOrderRepository extends JpaRepository<HotelOrder, UUID> {
    List<HotelOrder> findByCreatedAtAfterAndCreatedAtBeforeAndStateIn(Instant createdAtFrom, Instant createdAtTo,
                                                                      List<EHotelOrderState> hotelOrderStates);

    @Deprecated
    List<HotelOrder> findByUpdatedAtAfterAndUpdatedAtBeforeAndStateIn(Instant updatedAtFrom, Instant updatedAtTo,
                                                                      List<EHotelOrderState> hotelOrderStates);

    @Query("SELECT o FROM HotelOrder o INNER JOIN OrderItem oi ON o.id = oi.order.id" +
            "  WHERE o.updatedAt >= :updatedAtFrom AND o.updatedAt <= :updatedAtTo " +
            "  AND o.orderItems.size = 1 AND oi.workflow.entityType = :entityType " +
            "  AND o.state IN :hotelOrderStates" +
            "  ORDER BY o.updatedAt ASC")
    List<HotelOrder> findOrdersByItemTypeAndUpdatedAtAndStateIn(@Param("updatedAtFrom") Instant updatedAtFrom,
                                                                @Param("updatedAtTo") Instant updatedAtTo,
                                                                @Param("hotelOrderStates") List<EHotelOrderState> hotelOrderStates,
                                                                @Param("entityType") String entityType,
                                                                Pageable pageable);
}
