package ru.yandex.travel.orders.repository.cpa;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.entities.Order;

public interface CpaOrderRepository extends JpaRepository<Order, UUID> {
    @Query("SELECT o FROM Order o INNER JOIN OrderItem oi ON o.id = oi.order.id" +
            "  WHERE o.updatedAt >= :updatedAtFrom AND o.updatedAt <= :updatedAtTo " +
            "    AND o.displayType IN :displayTypes " +
            "  ORDER BY o.updatedAt ASC")
    @EntityGraph("order-for-cpa")
    List<Order> findOrdersByUpdatedAt(@Param("updatedAtFrom") Instant updatedAtFrom,
                                      @Param("updatedAtTo") Instant updatedAtTo,
                                      @Param("displayTypes") Collection<EDisplayOrderType> displayOrderTypes,
                                      Pageable pageable);
}
