package ru.yandex.travel.orders.repository.cpa;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.TrainOrder;

public interface CpaTrainOrderRepository extends JpaRepository<TrainOrder, UUID> {

    List<TrainOrder> findByCreatedAtAfterAndCreatedAtBefore(Instant createdAtFrom, Instant createdAtTo);

    @EntityGraph("order-for-cpa")
    @Deprecated
    List<TrainOrder> findByUpdatedAtAfterAndUpdatedAtBefore(Instant createdAtFrom, Instant createdAtTo);

    @Query("SELECT o FROM TrainOrder o INNER JOIN OrderItem oi ON o.id = oi.order.id" +
            "  WHERE o.updatedAt >= :updatedAtFrom AND o.updatedAt <= :updatedAtTo " +
            "  ORDER BY o.updatedAt ASC")
    @EntityGraph("order-for-cpa")
    List<TrainOrder> findOrdersByUpdatedAt(@Param("updatedAtFrom") Instant updatedAtFrom,
                                           @Param("updatedAtTo") Instant updatedAtTo,
                                           Pageable pageable);
}
