package ru.yandex.travel.orders.repository.finances;

import java.time.LocalDate;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.finances.BankOrderDetail;

public interface BankOrderDetailRepository extends JpaRepository<BankOrderDetail, Long> {
    @Query(
            value = "select SUM(bod.sum) from bank_order_details bod where bod.contract_id = ?1 and bod.payment_time <= ?2",
            nativeQuery = true
    )
    Double getBalanceByContractIdAtDate(Long contractId, LocalDate date);

    List<BankOrderDetail> findAllByYtId(Long ytId);
}
