package ru.yandex.travel.orders.repository.finances;

import java.time.Instant;
import java.util.List;
import java.util.Set;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.finances.BankOrderPayment;
import ru.yandex.travel.orders.entities.finances.BankOrderPaymentDetailsStatus;

public interface BankOrderPaymentRepository extends JpaRepository<BankOrderPayment, String> {
    Set<String> NO_EXCLUDE_IDS = Set.of("non_existent_payment_batch_id");

    @Query("SELECT bp.paymentBatchId FROM BankOrderPayment bp WHERE bp.status in ?1 " +
            " AND (bp.nextCheckAt is NULL OR bp.nextCheckAt < ?2) " +
            "AND bp.paymentBatchId NOT IN ?3 " +
            "ORDER BY bp.createdAt ASC")
    List<String> findIdsForDetailsSynchronization(
            Set<BankOrderPaymentDetailsStatus> status, Instant now, Set<String> excludeIds, Pageable pageable);

    @Query("SELECT count(bp) FROM BankOrderPayment bp WHERE bp.status in ?1 " +
            " AND (bp.nextCheckAt is NULL OR bp.nextCheckAt < ?2) " +
            " AND bp.paymentBatchId NOT IN ?3")
    long countIdsForDetailsSynchronization(Set<BankOrderPaymentDetailsStatus> status, Instant now,
                                           Set<String> excludeIds);
}
