package ru.yandex.travel.orders.repository.migrations;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.notifications.Attachment;

public interface AttachmentDataToS3MigrationRepository extends JpaRepository<Attachment, UUID> {
    @Query(value = "select id from Attachment where data is not null and id not in (:excludeIds)")
    List<UUID> findAttachmentIdsWithData(@Param("excludeIds") Collection<UUID> excludeIds, Pageable pageable);

    @Query(value = "select count(*) from Attachment where data is not null and id not in (:excludeIds)")
    Long countAttachmentIdsWithData(@Param("excludeIds") Collection<UUID> excludeIds);
}
