package ru.yandex.travel.orders.repository.migrations;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

import com.google.common.base.Preconditions;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.GenericOrder;
import ru.yandex.travel.orders.workflow.order.generic.proto.EOrderState;

public interface TrainToGenericMigrationRepository extends JpaRepository<GenericOrder, UUID> {
    @Query(value = "select o.id from TrainOrder o where id not in (:excludeIds)")
    List<UUID> findOldTrainOrderIds(@Param("excludeIds") Collection<UUID> excludeIds, Pageable pageable);

    @Query(value = "select count(*) from TrainOrder o where id not in (:excludeIds)")
    Long countOldTrainOrderIds(@Param("excludeIds") Collection<UUID> excludeIds);

    @Query(value = "update orders set order_type = 'generic_order', state = :newState, version = version + 1 " +
            "where id = :orderId and order_type = 'train_order'",
            nativeQuery = true)
    @Modifying
    int changeOldTrainOrderTypeAndState(@Param("orderId") UUID orderId, @Param("newState") int newState);

    default void changeOldTrainOrderTypeAndState(UUID orderId, EOrderState newState) {
        int updated = changeOldTrainOrderTypeAndState(orderId, newState.getNumber());
        Preconditions.checkState(updated == 1,
                "Exactly 1 record is expected to be updated for order %s but got %s", orderId, updated);
    }

    // the ", payload = '{}'" clause works only in Postgres, for local tests remove it
    @Query(value = "update order_refunds set refund_type = 'generic_order_user_refund', payload = '{}' " +
            "where id in (:refundIds)", nativeQuery = true)
    @Modifying
    int changeOldTrainRefundTypes(@Param("refundIds") Collection<UUID> refundIds);

    default void changeOldTrainRefundTypesStrict(Collection<UUID> refundIds) {
        int updated = changeOldTrainRefundTypes(refundIds);
        Preconditions.checkState(updated == refundIds.size(),
                "Exactly {} records are expected to be updated for ids %s but got %s",
                refundIds.size(), refundIds, updated);
    }
}
