package ru.yandex.travel.orders.repository.mock;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.commons.proto.EAviaMqEventOutcome;
import ru.yandex.travel.orders.entities.mock.MockAeroflotOrder;

public interface MockAeroflotOrderRepository extends JpaRepository<MockAeroflotOrder, UUID> {
    List<MockAeroflotOrder> findAllByMqEventResultInAndIdNotInAndSendMqEventAtBeforeOrderBySendMqEventAt(Collection<EAviaMqEventOutcome> eventOutcome,
                                                                                                         Collection<UUID> activeIds,
                                                                                                         Instant sendBefore,
                                                                                                         Pageable pageRequest);

    long countAllByMqEventResultInAndIdNotInAndSendMqEventAtNotNull(Collection<EAviaMqEventOutcome> eventOutcome,
                                                                    Collection<UUID> activeIds);
}
