package ru.yandex.travel.orders.repository.mock;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.mock.MockTrainOrder;

public interface MockTrainOrderRepository extends JpaRepository<MockTrainOrder, Integer> {
    @Query(value = "select nextval('mock_train_order_id_seq')", nativeQuery = true)
    Integer getNextOrderId();

    @Query(value = "select nextval('mock_train_order_item_id_seq')", nativeQuery = true)
    Integer getNextOrderItemId();

    @Query(value = "select nextval('mock_train_order_item_blank_id')", nativeQuery = true)
    Integer getNextBlankId();

    @Query(value = "select nextval('mock_train_order_customer_id')", nativeQuery = true)
    Integer getNextCustomerId();
}
