package ru.yandex.travel.orders.repository.mock;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.mock.MockTrustBasket;
import ru.yandex.travel.orders.services.payments.model.PaymentStatusEnum;

public interface MockTrustBasketRepository extends JpaRepository<MockTrustBasket, UUID> {
    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Query(value = "select nextval('mock_trust_order_id_seq')", nativeQuery = true)
    Long getNextOrderId();


    @Query("SELECT b.id FROM MockTrustBasket b WHERE b.userActionMustOccurAt < :now AND b.state = :state" +
            " AND b.id NOT IN (:ids)")
    List<UUID> findIdsReadyUserAction(@Param("now") Instant userActionMustOccurAt,
                                      @Param("state") PaymentStatusEnum paymentStatusEnum,
                                      @Param("ids") Collection<UUID> excludeIds,
                                      Pageable pageable);

    @Query("SELECT count(b.id) FROM MockTrustBasket b WHERE b.userActionMustOccurAt < :now AND b.state = :state " +
            " AND b.id NOT IN (:ids)")
    Long countBasketsReadyUserAction(@Param("now") Instant userActionMustOccurAt,
                                     @Param("state") PaymentStatusEnum paymentStatusEnum,
                                     @Param("ids") Collection<UUID> excludeIds);

    @Query("SELECT b.id FROM MockTrustBasket b WHERE b.state in (:states) AND b.sendCallback = true AND b" +
            ".callbackSentAt " +
            "IS NULL AND b.id NOT IN (:ids)")
    List<UUID> findIdsReadyForCallback(@Param("states") Collection<PaymentStatusEnum> statusesToNotify,
                                       @Param("ids") Collection<UUID> excludeIds,
                                       Pageable pageable);


    @Query("SELECT count(b.id) FROM MockTrustBasket b WHERE b.state in :states AND b.sendCallback = true " +
            "AND b.callbackSentAt IS NULL AND b.id NOT IN :ids")
    Long countBasketsReadyForCallback(@Param("states") Collection<PaymentStatusEnum> statusesToNotify,
                                      @Param("ids") Collection<UUID> excludeIds);
}
