package ru.yandex.travel.orders.repository.promo;

import java.util.Optional;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.promo.PromoAction;

public interface PromoActionRepository extends JpaRepository<PromoAction, UUID> {
    Optional<PromoAction> findByName(String name);

    @Query(value = "select nextval('simple_promo_code_generation_strategy_seq')", nativeQuery = true)
    Long getNextSimpleGenerationStrategySequenceValue();
}
