package ru.yandex.travel.orders.repository.promo;

import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.promo.PromoCodeActivation;

public interface PromoCodeActivationRepository extends JpaRepository<PromoCodeActivation, UUID> {

    @Query("SELECT pa FROM PromoCodeActivation pa WHERE pa.passportId = :passportId AND pa.promoCode.id = :promoCodeId")
    PromoCodeActivation lookupActivationForPromoCodeAndPassportId(@Param("passportId") String passportId,
                                                                  @Param("promoCodeId") UUID promoCodeId);

    @Query("SELECT pa FROM PromoCodeActivation pa WHERE pa.passportId = :passportId AND pa.promoCode.code = :code")
    PromoCodeActivation lookupActivationByCodeAndPassportId(@Param("passportId") String passportId,
                                                            @Param("code") String code);

    @Query("SELECT COALESCE(SUM(pa.timesUsed), 0) FROM PromoCodeActivation pa WHERE pa.promoCode.id = :promoCodeId")
    Integer countActivationsByPromoCode(@Param("promoCodeId") UUID promoCodeId);
}
