package ru.yandex.travel.orders.repository.promo.aeroflotplus;

import java.util.List;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.promo.aeroflotplus.AeroflotPlusPromoCode;

public interface AeroflotPlusPromoCodeRepository extends JpaRepository<AeroflotPlusPromoCode, String> {
    default List<AeroflotPlusPromoCode> findFreeCodes(int n) {
        List<AeroflotPlusPromoCode> results = findByUsedAtIsNullOrderByAddedAtAsc(PageRequest.of(0, n));
        if (results.size() != n) {
            throw new RuntimeException(String.format("Failed to find %s free codes, only %s left", n, results.size()));
        }
        return results;
    }

    List<AeroflotPlusPromoCode> findByUsedAtIsNullOrderByAddedAtAsc(Pageable paging);

    long countByUsedAtIsNull();
}
