package ru.yandex.travel.orders.repository.promo.taxi2020;

import java.util.List;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.promo.taxi2020.Taxi2020PromoCode;

public interface Taxi2020PromoCodeRepository extends JpaRepository<Taxi2020PromoCode, String> {
    default Taxi2020PromoCode findAnyByUsedAtIsNull() {
        List<Taxi2020PromoCode> results = findByUsedAtIsNullOrderByAddedAtAsc(PageRequest.of(0, 1));
        return results.isEmpty() ? null : results.get(0);
    }

    List<Taxi2020PromoCode> findByUsedAtIsNullOrderByAddedAtAsc(Pageable paging);

    long countByUsedAtIsNull();
}
