package ru.yandex.travel.orders.repository.promo.taxi2020;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.promo.taxi2020.Taxi2020PromoOrder;

public interface Taxi2020PromoOrderRepository extends JpaRepository<Taxi2020PromoOrder, UUID> {
    @Query("select po " +
            "from Taxi2020PromoOrder po " +
            "   join HotelOrder ho on po.orderId = ho.id " +
            "   join OrderItem oi on ho = oi.order " +
            "where po.status = 'promo_code_can_be_assigned' or ( " +
            "   po.status = 'eligible' and po.emailScheduledAt <= :now" +
            " ) or (" +
            "   po.status in ('eligible', 'not_eligible') and " +
            "   po.statusUpdatedAt < greatest(ho.updatedAt, oi.updatedAt)" +
            ")")
    List<Taxi2020PromoOrder> findOrdersToCheck(@Param("now") Instant now, Pageable pageable);

    @Query("select count(po) " +
            "from Taxi2020PromoOrder po " +
            "   join HotelOrder ho on po.orderId = ho.id " +
            "   join OrderItem oi on ho = oi.order " +
            "where po.status = 'promo_code_can_be_assigned' or ( " +
            "   po.status = 'eligible' and po.emailScheduledAt <= :now" +
            " ) or (" +
            "   po.status in ('eligible', 'not_eligible') and " +
            "   po.statusUpdatedAt < greatest(ho.updatedAt, oi.updatedAt)" +
            ")")
    long countOrderToCheck(@Param("now") Instant now);
}
