package ru.yandex.travel.orders.repository.support

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.Query
import org.springframework.data.repository.query.Param
import org.springframework.stereotype.Repository
import ru.yandex.travel.orders.entities.HotelOrderItem
import ru.yandex.travel.orders.entities.support.SuccessfulHotelOrderNotification
import java.time.Instant
import java.util.*

@Repository
interface SuccessfulHotelOrderNotificationRepository : JpaRepository<SuccessfulHotelOrderNotification, UUID> {
    fun findBySentAtIsNull(): List<SuccessfulHotelOrderNotification>

    @Query(
        // o.state = 8  is EHotelOrderState.OS_CONFIRMED
    """
        select oi from OrderItem oi
        join oi.order o
        where type(o) = HotelOrder
            and o.state = 8
            and o.createdAt >= :since
            and not exists (select 1 from SuccessfulHotelOrderNotification t where t.orderId = o.id)
        """)
    fun selectNewConfirmedOrders(@Param("since") since: Instant): List<HotelOrderItem>

    @Query("""
        select new ru.yandex.travel.orders.repository.support.OrdersCountByPermalink(hon.permalink, count(hon.orderId))
        from SuccessfulHotelOrderNotification hon
        where
            hon.permalink in :permalinks
        group by hon.permalink
    """)
    fun countForPermalinks(@Param("permalinks") permalinks: List<Long>): List<OrdersCountByPermalink>
}

data class OrdersCountByPermalink(var permalink: Number, var count: Number)
