package ru.yandex.travel.orders.repository.support;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.support.UnsuccessfulHotelOrderNotification;

public interface UnsuccessfulHotelOrderNotificationRepository extends JpaRepository<UnsuccessfulHotelOrderNotification, UUID> {
    @Modifying
    @Query(value = "insert into support_unsuccessful_hotel_order_notifications(order_id, passport_id, session_key)\n" +
            "WITH new_orders_with_auth as (\n" +
            "        select o.id, o.state, o.created_at, o.workflow_id, au.passport_id, au.session_key\n" +
            "        from orders o join authorized_users au on o.id = au.order_id\n" +
            "        where au.role = 'OWNER' and o.order_type = 'hotel_order' and o.created_at >= :since\n" +
            "            and not exists (select 1 from support_unsuccessful_hotel_order_notifications where order_id = o.id)\n" +
            "    ),\n" +
            "    failed_orders as (\n" +
            "        select o.*\n" +
            "        from new_orders_with_auth o join workflows w on o.workflow_id = w.id\n" +
            "        where o.state not in (8, 10)\n" + // not (OS_CONFIRMED, OS_REFUNDED)
            "            and w.state != 4\n" + // not WS_CRASHED
            "    ),\n" +
            "    successful_orders as (\n" +
            "        select o.*\n" +
            "        from new_orders_with_auth o\n" +
            "        where o.state in (8, 10)\n" + // (OS_CONFIRMED, OS_REFUNDED)
            "    ),\n" +
            "    failure_streak as (\n" +
            "        select f.*\n" +
            "        from failed_orders f left join successful_orders c\n" +
            "            on f.passport_id = c.passport_id and f.session_key = c.session_key and f.created_at < c.created_at\n" +
            "        where c.id is null\n" +
            "    )\n" +
            "select id, passport_id, session_key\n" +
            "from failure_streak fs\n" +
            "where (\n" +
            "    select min(fo.created_at)\n" +
            "    from failure_streak fo\n" +
            "    where fs.passport_id = fo.passport_id and fs.session_key = fo.session_key\n" +
            ") between :since and :till",
            nativeQuery = true)
    int copyNewUnconfirmedOrders(@Param("since") Instant since, @Param("till") Instant till);

    @Query("select n " +
            "from UnsuccessfulHotelOrderNotification n inner join n.order o " +
            "where n.sentAt is null " +
            "order by o.createdAt asc")
    List<UnsuccessfulHotelOrderNotification> findNotSentOrdered();
}
