package ru.yandex.travel.orders.services;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.commons.proto.EAdminAction;
import ru.yandex.travel.orders.entities.AdminUserActionAuditRecord;
import ru.yandex.travel.orders.repository.AdminUserActionAuditRecordRepository;
import ru.yandex.travel.tx.utils.TransactionMandatory;

@Service
@RequiredArgsConstructor
public class AdminUserActionAuditService {
    private final AdminUserActionAuditRecordRepository logRecordRepository;

    @TransactionMandatory
    public void auditOrderAction(String login, UUID orderId, EAdminAction action, String description) {
        AdminUserActionAuditRecord logRecord = new AdminUserActionAuditRecord();
        logRecord.setOrderId(orderId);
        logRecord.setUserLogin(login);
        logRecord.setAction(action);
        logRecord.setDescription(description);
        logRecordRepository.save(logRecord);
    }
}
