package ru.yandex.travel.orders.services;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "exchange", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class ExchangeRateConfigurationProperties {
    @NotNull
    private Boolean enabled;
    @NotEmpty
    private String url;
    @NotNull
    private Duration shutdownTimeout;
    @NotNull
    private Duration refreshInterval;
    @NotNull
    private Duration validityInterval;
    @NotNull
    private Integer commissionPercent;
}
