package ru.yandex.travel.orders.services;

import javax.validation.constraints.NotEmpty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "mail", ignoreUnknownFields = false)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Validated
public class MailSenderConfigurationProperties {
    @NotEmpty
    private String templatedMailerUrlBase;
    @NotEmpty
    private String mailerUrlBase;
    @NotEmpty
    private String authenticationKey;

    private DebugProperties debug;

    @Getter
    @Setter
    @Validated
    public static class DebugProperties {
        private boolean enabled;
        private String failEmail;
    }
}
