package ru.yandex.travel.orders.services;

import com.google.common.base.Strings;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.commons.proto.EErrorCode;
import ru.yandex.travel.commons.proto.Error;
import ru.yandex.travel.credentials.UserCredentials;
import ru.yandex.travel.orders.proto.TUserInfo;

public class OrderOwnerValidator {
    public static void validateYandexUid(TUserInfo owner, UserCredentials credentials) {
        if (!owner.getYandexUid().equals(credentials.getYandexUid())) {
            throw Error.with(EErrorCode.EC_INVALID_ARGUMENT, "yandex uid mismatch")
                    .withAttribute("owner_yandex_uid", Strings.nullToEmpty(owner.getYandexUid()))
                    .withAttribute("credentials_yandex_uid", Strings.nullToEmpty(credentials.getYandexUid()))
                    .toEx();
        }
    }
    public static void validateIfLoggedIn(TUserInfo owner, UserCredentials credentials) {
        if (StringUtils.isNotBlank(owner.getPassportId()) || credentials.isLoggedIn()) {
            if (!owner.getPassportId().equals(credentials.getPassportId())) {
                throw Error.with(EErrorCode.EC_INVALID_ARGUMENT, "passport id mismatch")
                        .withAttribute("owner_passport_id", Strings.nullToEmpty(owner.getPassportId()))
                        .withAttribute("credentials_passport_id", Strings.nullToEmpty(credentials.getPassportId()))
                        .toEx();
            }
            if (!owner.getLogin().equals(credentials.getLogin())) {
                // Excluding the case of a user registered via an external email
                if (!(owner.getLogin().equals("") && credentials.getLogin() == null)) {
                    throw Error.with(EErrorCode.EC_INVALID_ARGUMENT, "login mismatch")
                            .withAttribute("owner_login", Strings.nullToEmpty(owner.getLogin()))
                            .withAttribute("credentials_login", Strings.nullToEmpty(credentials.getLogin()))
                            .toEx();
                }
            }
        }
    }
}
