package ru.yandex.travel.orders.services;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsRsp;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.entities.AuthorizedUser;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.proto.TPromoForOffer;
import ru.yandex.travel.orders.services.promo.PromoCodeApplicationResult;
import ru.yandex.travel.orders.services.promo.ServiceDescription;
import ru.yandex.travel.proto.BaseTypes;
import ru.yandex.travel.white_label.proto.EWhiteLabelPartnerId;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;

/**
 * Wrapper for {@link ru.yandex.travel.hotels.services.promoservice.PromoServiceClient}
 */
public interface PromoServiceHelper {
    CompletableFuture<List<TPromoForOffer>> determinePromosForOffers(List<ServiceDescription> serviceDescriptions,
                                                                     PromoCodeApplicationResult result,
                                                                     List<EDisplayOrderType> userExistingOrderTypes,
                                                                     List<BaseTypes.TStringPair> kVExperiments,
                                                                     EWhiteLabelPartnerId whiteLabelPartnerId);

    /**
     * Validates the order with promo service. Can correct plus points to a higher value.
     * <p>
     * All the discounts and promo codes should be applied. Checks the promo code discount in
     * <code>order.promoCodeApplications.discount</code>.
     */
    CompletableFuture<Void> validateAppliedPromoCampaigns(Order order,
                                                          AuthorizedUser authorizedUser,
                                                          List<EDisplayOrderType> userExistingOrderTypes);

    CompletableFuture<TGetWhiteLabelPointsPropsRsp> getWhiteLabelPointsProps(EWhiteLabelPointsType pointsType,
                                                                             int amount);
}
