package ru.yandex.travel.orders.services;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class TimeHelpers {
    public static final String MSK_TZ = "Europe/Moscow";
    public static final ZoneId MSK_ZONE = ZoneId.of(MSK_TZ);

    public static LocalDateTime toLocalDateTime(Instant dateTime, String zone) {
        if (dateTime == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.of(zone);
        return dateTime.atZone(zoneId).toLocalDateTime();
    }
}
